local SCROLL_NAME = "Scroll of Deception"

-- Create main frame
local frame = CreateFrame("Frame")
frame:RegisterEvent("CHAT_MSG_LOOT")

-- Popup frame (hidden by default)
local popup = CreateFrame("Frame", "ScrollAlertPopup", UIParent)
popup:SetSize(300, 120)
popup:SetPoint("CENTER")
popup:SetBackdrop({
    bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
    tile = true,
    tileSize = 32,
    edgeSize = 32,
    insets = { left = 8, right = 8, top = 8, bottom = 8 }
})
popup:SetFrameStrata("DIALOG")
popup:Hide()

-- Text
popup.text = popup:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
popup.text:SetPoint("CENTER", 0, 15)
popup.text:SetText("You looted a Scroll of Deception!")

-- OK Button
popup.button = CreateFrame("Button", nil, popup, "UIPanelButtonTemplate")
popup.button:SetSize(80, 22)
popup.button:SetPoint("BOTTOM", 0, 15)
popup.button:SetText("OK")
popup.button:SetScript("OnClick", function()
    popup:Hide()
end)

-- Event handler
frame:SetScript("OnEvent", function(self, event, message)
    if string.find(message, SCROLL_NAME) then
        -- Play sound
        PlaySound(9656)

        -- Show popup
        popup:Show()
    end
end)
