local _, BigBrother = ...

local module = BigBrother:NewModule("LDB")
local L = LibStub("AceLocale-3.0"):GetLocale("BigBrother")
local LDBIcon = LibStub("LibDBIcon-1.0")

local DataBroker = LibStub("LibDataBroker-1.1"):NewDataObject("BigBrother", {
	type = "launcher",
	label = "BigBrother",
	icon = [[Interface\AddOns\BigBrother\icon]],
	OnClick = function(frame, button)
		if button == "RightButton" then
			local Config = BigBrother:GetModule("Config", true)
			if Config then
				Config:OpenOptions()
			end
		else
			local BuffCheck = BigBrother:GetModule("BuffCheck", true)
			if BuffCheck then
				BuffCheck:ToggleWindow()
			end
		end
	end,
	OnTooltipShow = function(tooltip)
		if tooltip and tooltip.AddLine then
			tooltip:SetText("BigBrother")
			tooltip:AddLine(L["|cffff8040Left Click|r to toggle the buff window"])
			tooltip:AddLine(L["|cffff8040Right Click|r to open the options window"])
			tooltip:Show()
		end
	end,
})

function module:OnInitialize()
	self.db = BigBrother.db:RegisterNamespace("LDB", {
		profile = {
			minimap = {
				hidden = false,
			},
		}
	})
	
	if LDBIcon then
		LDBIcon:Register("BigBrother", DataBroker, self.db.profile.minimap)
	end
end

function module:AddOptions(options)
	if not LDBIcon then return end
	
	options.args.minimap = {
		name = L["Hide minimap button"],
		--desc = L["Hide minimap button"],
		type = 'toggle',
		get = function() return self.db.profile.minimap.hide end,
		set = function(_, v)
			self.db.profile.minimap.hide = v 
			if self.db.profile.minimap.hide then
				LDBIcon:Hide("BigBrother")
			else
				LDBIcon:Show("BigBrother")
			end
		end,
		order = 10,
		width = "full",
	}
end
