local _, BigBrother = ...

local module = BigBrother:NewModule("Config")
local L = LibStub("AceLocale-3.0"):GetLocale("BigBrother")
local LDBIcon = LibStub("LibDBIcon-1.0")
local BuffCheck = BigBrother:GetModule("BuffCheck", true)

local function GetOptions()
	local options = {
		type = 'group',
		childGroups = "tab",
		args = {
			confdesc = {
				name = GetAddOnMetadata("BigBrother", "Notes").."\n",
				type = "description",
				order = 1,
				width = "full",
			},
			quickcheck = {
				name = L["Quick Check"],
				desc = L["A quick report that shows who does not have flasks, elixirs or food."],
				type = "execute",
				handler = BigBrother,
				func = "ConsumableCheck",
				order = 5,
				width = "full",
			},
			checks = {
				type = "group",
				name = "Checks",
				get = function(info) return BigBrother.db.profile[info[#info]] end,
				set = function(info, value) BigBrother.db.profile[info[#info]] = value end,
				order = 1,
				args = {
					checks = {
						name = L["Checks"],
						desc = L["Set what is included in the Quick Check"],
						type = 'group',
						inline = true,
						order = 10,
						args = {
							checkFlasks = {
								name  = L["Flasks/Elixirs"],
								desc = L["Include flasks and elixirs in checks"],
								type = 'toggle',
								order = 5,
							},
							checkFood = {
								name  = L["Food Buffs"],
								desc = L["Include food buffs in checks"],
								type = 'toggle',
								order = 15,
							},
						},
					}, --checks
					groups = {
						name = L["Checked Raid Groups"],
						desc = L["Set which raid groups are checked for buffs"],
						type = 'group',
						inline = true,
						order = 20,
						disabled = function() return BigBrother.db.profile.autogroups end,
						args = {
							autogroups = {
								name = L["Use Raid Difficulty"],
								desc = L["Use the currently selected raid difficulty to determine which groups to check"],
								type = "toggle",
								get = function() return BigBrother.db.profile.autogroups end,
								set = function(_, v) BigBrother.db.profile.autogroups = v end,
								width = "full",
								order = 1,
								disabled = false,
							},
							group1 = {
								name  = L["Group 1"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[1] end,
								set = function(_, v) BigBrother.db.profile.groups[1] = v end,
								order = 11,
							},
							group2 = {
								name  = L["Group 2"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[2] end,
								set = function(_, v) BigBrother.db.profile.groups[2] = v end,
								order = 12,
							},
							group3 = {
								name  = L["Group 3"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[3] end,
								set = function(_, v) BigBrother.db.profile.groups[3] = v end,
								order = 13,
							},
							group4 = {
								name  = L["Group 4"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[4] end,
								set = function(_, v) BigBrother.db.profile.groups[4] = v end,
								order = 14,
							},
							group5 = {
								name  = L["Group 5"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[5] end,
								set = function(_, v) BigBrother.db.profile.groups[5] = v end,
								order = 15,
							},
							group6 = {
								name  = L["Group 6"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[6] end,
								set = function(_, v) BigBrother.db.profile.groups[6] = v end,
								order = 16,
							},
							group7 = {
								name  = L["Group 7"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[7] end,
								set = function(_, v) BigBrother.db.profile.groups[7] = v end,
								order = 17,
							},
							group8 = {
								name  = L["Group 8"],
								type = 'toggle',
								get = function() return BigBrother.db.profile.groups[8] end,
								set = function(_, v) BigBrother.db.profile.groups[8] = v end,
								order = 18,
							},
						},
					}, --groups
					checkReadyCheck = {
						name  = L["Check on Ready Check"],
						desc = L["Quick Check in raid chat when starting a ready check"],
						type = 'toggle',
						order = 30,
						width = "full"
					}, --checkReadyCheck
				},
			}, --checks
			
		},
	}
	
	for _,module in BigBrother:IterateModules() do
		if module.AddOptions then
			module:AddOptions(options)
		end
	end
	
	options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(BigBrother.db)
	options.args.profile.desc = nil
	options.args.profile.order = 100
	
	return options
end

function module:OnInitialize()
	LibStub("AceConfig-3.0"):RegisterOptionsTable("BigBrother", GetOptions)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("BigBrother")
end

function module:OpenOptions()
	InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
end

local function ChatCommand(input, editbox)
	local command, rest = string.match(input, "^(%S*)%s*(.-)$")
	if command == "quickcheck" or command == "qc" then
		BigBrother:ConsumableCheck(rest)
	elseif command == "buffcheck" or command == "bc" then
		BuffCheck:ToggleBuffWindow()
	elseif command == "settings" then
		module:OpenOptions()
	else
		BigBrother:Print("|cffffff7f/bb quickcheck [self||group||party||raid||guild||officer]|r: " .. L["A quick report that shows who does not have flasks, elixirs or food."]) -- Can optionally specify where to output the check results (defaults to self)
		BigBrother:Print("|cffffff7f/bb buffcheck|r: " .. L["Pops up a window to check raid buffs (drag the bottom to resize)."])
		BigBrother:Print("|cffffff7f/bb settings|r: " .. L["Open settings."])
	end
end

SLASH_BIGBROTHER1 = "/bigbrother"
SLASH_BIGBROTHER2 = "/bb"
SlashCmdList["BIGBROTHER"] = ChatCommand
