local _, BigBrother = ...

BigBrother = LibStub("AceAddon-3.0"):NewAddon(BigBrother, "BigBrother", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("BigBrother")

--localize names for lookup
local flaskBuffs = {}
for i,v in ipairs(BigBrother.SpellData.flasks) do
	flaskBuffs[i] = GetSpellInfo(v)
end

local elixirBuffs = {}
for i,v in ipairs(BigBrother.SpellData.elixirsBattle) do
	elixirBuffs[i] = GetSpellInfo(v)
end
for i,v in ipairs(BigBrother.SpellData.elixirsGuardian) do
	elixirBuffs[i] = GetSpellInfo(v)
end

local foodBuffs = {}
for i,v in ipairs(BigBrother.SpellData.foods) do
	foodBuffs[i] = GetSpellInfo(v)
end


function BigBrother:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("BigBrotherDB", {
		profile = {
			autogroups = true,
			groups = { true, true, true, true, true, true, true, true },
			checkFlasks = true,
			checkElixirs = true,
			checkFood = true,
			checkReadyCheck = true,
		}
	})
end

function BigBrother:OnEnable()
	self:RegisterEvent("READY_CHECK")
end

function BigBrother:Print(msg)
	DEFAULT_CHAT_FRAME:AddMessage(string.format("|cff33ff99BigBrother|r: %s", msg))
end

--adapted from BigWigs:GetInstanceDifficulty()
function BigBrother:GetInstanceSize()
	local _, instanceType, diff, _, _, heroic, dynamic = GetInstanceInfo()
	if instanceType == "none" or instanceType == "pvp" then --GetZonePVPInfo() == "combat" for WG
		return 40
	elseif instanceType == "raid" and dynamic and heroic == 1 and diff <= 2 then
		diff = diff + 2
	elseif instanceType == "party" or instanceType == "arena" then
		return 5
	end
	
	diff = type(diff) == "number" and diff or 1
  if diff == 1 or diff == 3 then
		return 10
	elseif diff == 2 or diff == 4 then
		return 25
	end
end

local SendChatMessageList
do
	local chatTypes = {
		SELF = true, SAY = true, GROUP = true, PARTY = true, GUILD = true, OFFICIER = true, RAID = true, RAID_WARNING = true, WHISPER = true,
	}
	function SendChatMessageList(title, list, channel)
		channel = channel and string.upper(channel)
		if not channel or not chatTypes[channel] then
			channel = "SELF"
			--BigBrother:Print("Invalid channel, set to \"SELF\".")
		end
		
		table.sort(list)
		local names = table.concat(list, ", ")
		
		if channel == "SELF" then
			BigBrother:Print(("|cffff8040%s (%d)|r: %s"):format(title, #list, names))
		else
			local target = nil
			if channel == "WHISPER" then
				target = UnitName("target") or UnitName("player")
			elseif channel == "GROUP" then
				if GetNumRaidMembers() > 0 then
					channel = "RAID"
				elseif GetNumPartyMembers() > 0 then
					channel = "PARTY"
				else
					return --abort!
				end
			end
			SendChatMessage(("%s (%d): %s"):format(title, #list, names), channel, nil, target)
		end
	end
end

do
	local fiveManGroups = { true }
	local tenManGroups = { true, true }
	local twentyFiveManGroups = { true, true, true, true, true }
	local allGroups = { true, true, true, true, true, true, true, true }
	
	function BigBrother:GetCheckedGroups()
		if self.db.profile.autogroups then
			local size = self:GetInstanceSize()
			if size == 25 then
				return twentyFiveManGroups
			elseif size == 10 then
				return tenManGroups
			elseif size == 5 then
				return fiveManGroups
			else
				return allGroups
			end
		else
			return self.db.profile.groups
		end
	end
end

do
	local partyUnits = {"player"}
	for i = 1, MAX_PARTY_MEMBERS do
		partyUnits[#partyUnits + 1] = ("party%d"):format(i)
	end
	local raidUnits = {}
	for i = 1, MAX_RAID_MEMBERS do
		raidUnits[#raidUnits + 1] = ("raid%d"):format(i)
	end
	
	function BigBrother:ConsumableCheck(channel)
		local inRaid = GetNumRaidMembers() > 0
		
		local groups = self:GetCheckedGroups()
		
		local missingFlaskList = {}
		local missingElixirList = {}
		local missingFoodList = {}
		
		for i, unit in ipairs(inRaid and raidUnits or partyUnits) do
			local name = UnitName(unit)
			if not name then break end
			local subgroup = inRaid and select(3, GetRaidRosterInfo(i)) or 1
			local online = UnitIsConnected(unit)
			local dead = UnitIsDeadOrGhost(unit)
			
			if online and not dead and groups[subgroup] then
				
				--check flasks/elixirs
				if self.db.profile.checkFlasks then
					local numElixirs = 0
					for _,spellName in next, elixirBuffs do
						if UnitBuff(name, spellName) then
							numElixirs = numElixirs + 1
						end
					end
					
					if numElixirs == 1 then
						missingElixirList[#missingElixirList + 1] = name
						
					elseif numElixirs == 0 then
						local found = nil
						for _,spellName in next, flaskBuffs do
							if UnitBuff(name, spellName) then
								found = true
								break
							end
						end
						if not found then
							missingFlaskList[#missingFlaskList + 1] = name
						end
						
					end
				end
				
				--check food
				if self.db.profile.checkFood then
					local found = nil
					for _,spellName in next, foodBuffs do
						if UnitBuff(name, spellName) then
							found = true
							break
						end
					end
					if not found then
						missingFoodList[#missingFoodList + 1] = name
					end
				end
				
			end --if
		end --for
		
		if #missingElixirList > 0 then
			SendChatMessageList(L["One Elixir"], missingElixirList, channel)
		end
		if #missingFlaskList > 0 then
			SendChatMessageList(L["No Flask"], missingFlaskList, channel)
		end
		if #missingFoodList > 0 then
			SendChatMessageList(L["Not Well Fed"], missingFoodList, channel)
		end
	end
end
	
function BigBrother:READY_CHECK(_, sender)
	if not self.db.profile.checkReadyCheck then return end
	if UnitIsUnit(sender, "player") and GetNumRaidMembers() > 0 then
		self:ConsumableCheck("RAID")
	end
end
